<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_agriculteur_liste
 *
 * @copyright   Copyright (C) 2025 Votre Nom. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;

// Inclure le fichier d'aide du module de profil
require_once JPATH_SITE . '/modules/mod_agriculteur_profil/helper.php';

// Acces a la base de donnees
$db = Factory::getDbo();

// Recuperer les agriculteurs - on prend le formId des parametres
$formId = $params->get('form_id', 1);

// Recuperer l'application
$app = Factory::getApplication();

// Recuperer la categorie a filtrer depuis l'URL
$filterCategory = $app->input->getString('category', '');

// Liste des categories valides
$validCategories = [
    'Agriculteur',
    'Commerce bio',
    'Transformateur',
    'Restaurateur',
    'Tables et gîte',
    'Autres'
];

// Requete pour recuperer tous les IDs
$query = $db->getQuery(true)
    ->select('s.SubmissionId')
    ->from($db->quoteName('#__rsform_submissions', 's'))
    ->where($db->quoteName('s.FormId') . ' = ' . $db->quote($formId))
    ->order($db->quoteName('s.DateSubmitted') . ' DESC');

$db->setQuery($query);
$submissionIds = $db->loadColumn();

// Initialiser le helper
$helper = new ModAgriculteurProfilHelper();

// Tableau pour stocker les agriculteurs et leurs distances
$agriculteurs = [];

// Position de l'utilisateur (a recuperer via HTML5 Geolocation API)
// Par defaut, coordonnees du centre de La Reunion
$userLat = -21.115141;
$userLng = 55.536384;

// Parcourir les soumissions et recuperer les donnees
foreach ($submissionIds as $submissionId) {
    $profileData = $helper->getProfileDataBySubmissionId($submissionId);
    
    if ($profileData) {
        // Verifier si un filtre de categorie est demande
        if (!empty($filterCategory)) {
            // Recuperer les categories de cet agriculteur
            $categoryRaw = isset($profileData['categories_raw']) ? $profileData['categories_raw'] : '';
            
            // Si la categorie n'est pas presente dans la chaine, passer au suivant
            // Note: nous verifions si la categorie est presente dans la chaine, pas uniquement exactement egale
            if (strpos($categoryRaw, $filterCategory) === false) {
                continue;
            }
            
            // Ignorer "Petit Commercant" qui est une ancienne entree de test
            if (strpos($categoryRaw, 'Petit Commerçant') !== false) {
                continue;
            }
        }
        
        // Initialiser la distance a 0 (sera calculee cote client avec l'API Google Maps)
        $distance = 0;
        
        // Recuperer l'URL de l'image de couverture
        $coverImageUrl = !empty($profileData['photo_couverture_petit_format_url']) 
            ? $profileData['photo_couverture_petit_format_url'] 
            : $helper->getUploadPath($profileData['photo_couverture_petit_format']);
            
        // Si pas d'image de couverture, utiliser une image par defaut
        if (empty($coverImageUrl)) {
            $coverImageUrl = Uri::root() . 'media/mod_agriculteur_liste/images/default-cover.jpg';
        }
        
        // Ajouter les donnees a notre tableau
        $agriculteurs[] = [
            'id' => $submissionId,
            'societe' => $profileData['societe'],
            'nom' => $profileData['nom'],
            'prenom' => $profileData['prenom'],
            'distance' => $distance,
            'image' => $coverImageUrl,
            'coordinates' => $profileData['geolocalisation']
        ];
    }
}

// Charger les styles et scripts necessaires
$document = Factory::getDocument();

// Chargement des styles CSS
if ($params->get('load_styles', 1)) {
    $cssFile = 'media/mod_agriculteur_liste/css/style.css';
    if (file_exists(JPATH_SITE . '/' . $cssFile)) {
        HTMLHelper::_('stylesheet', $cssFile, ['version' => 'auto']);
    }
}

// Chargement du script JavaScript principal
$document->addScript(Uri::root() . 'modules/mod_agriculteur_liste/js/geoloc.js', ['version' => 'auto']);

// Inclure le template d'affichage
require ModuleHelper::getLayoutPath('mod_agriculteur_liste', $params->get('layout', 'default'));
